/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.generic;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.pageinformation.PageInformationFlags;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.region.RegionFlags;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.generic.GenericRegionFlags;

public class GenericRegionSegment
extends RegionSegment {
    private GenericRegionFlags genericRegionFlags = new GenericRegionFlags();
    private boolean inlineImage;
    private boolean unknownLength = false;

    public GenericRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    public void readSegment() throws IOException, JBIG2Exception {
        if (JBIG2StreamDecoder.debug) {
            System.out.println("==== Reading Immediate Generic Region ====");
        }
        super.readSegment();
        this.readGenericRegionFlags();
        boolean useMMR = this.genericRegionFlags.getFlagValue(GenericRegionFlags.MMR) != 0;
        int template = this.genericRegionFlags.getFlagValue(GenericRegionFlags.GB_TEMPLATE);
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        if (!useMMR) {
            if (template == 0) {
                genericBAdaptiveTemplateX[0] = this.readATValue();
                genericBAdaptiveTemplateY[0] = this.readATValue();
                genericBAdaptiveTemplateX[1] = this.readATValue();
                genericBAdaptiveTemplateY[1] = this.readATValue();
                genericBAdaptiveTemplateX[2] = this.readATValue();
                genericBAdaptiveTemplateY[2] = this.readATValue();
                genericBAdaptiveTemplateX[3] = this.readATValue();
                genericBAdaptiveTemplateY[3] = this.readATValue();
            } else {
                genericBAdaptiveTemplateX[0] = this.readATValue();
                genericBAdaptiveTemplateY[0] = this.readATValue();
            }
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        boolean typicalPredictionGenericDecodingOn = this.genericRegionFlags.getFlagValue(GenericRegionFlags.TPGDON) != 0;
        int length = this.segmentHeader.getSegmentDataLength();
        if (length == -1) {
            short match2;
            short match1;
            this.unknownLength = true;
            if (useMMR) {
                match1 = 0;
                match2 = 0;
            } else {
                match1 = 255;
                match2 = 172;
            }
            int bytesRead = 0;
            while (true) {
                short bite1 = this.decoder.readByte();
                ++bytesRead;
                if (bite1 != match1) continue;
                short bite2 = this.decoder.readByte();
                ++bytesRead;
                if (bite2 == match2) break;
            }
            length = bytesRead - 2;
            this.decoder.movePointer(-bytesRead);
        }
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        bitmap.clear(0);
        bitmap.readBitmap(useMMR, template, typicalPredictionGenericDecodingOn, false, null, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY, useMMR ? 0 : length - 18);
        if (this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegement(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            int extCombOp = this.regionFlags.getFlagValue(RegionFlags.EXTERNAL_COMBINATION_OPERATOR);
            if (pageSegment.getPageBitmapHeight() == -1 && this.regionBitmapYLocation + this.regionBitmapHeight > pageBitmap.getHeight()) {
                pageBitmap.expand(this.regionBitmapYLocation + this.regionBitmapHeight, pageSegment.getPageInformationFlags().getFlagValue(PageInformationFlags.DEFAULT_PIXEL_VALUE));
            }
            pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, extCombOp);
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
        if (this.unknownLength) {
            this.decoder.movePointer(4);
        }
    }

    private void readGenericRegionFlags() throws IOException {
        short genericRegionFlagsField = this.decoder.readByte();
        this.genericRegionFlags.setFlags(genericRegionFlagsField);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("generic region Segment flags = " + genericRegionFlagsField);
        }
    }

    public GenericRegionFlags getGenericRegionFlags() {
        return this.genericRegionFlags;
    }
}

