/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Library;

public class Separation
extends PColorSpace {
    protected Color namedColor;
    protected PColorSpace alternate;
    protected Function tintTransform;
    private boolean isAll;
    public static final String COLORANT_ALL = "All";
    private boolean isNone;
    public static final String COLORANT_NONE = "None";
    private float tint = 1.0f;

    protected Separation(Library l, Hashtable h, Object name, Object alternateSpace, Object tintTransform) {
        super(l, h);
        this.alternate = Separation.getColorSpace(l, alternateSpace);
        this.tintTransform = Function.getFunction(l, l.getObject(tintTransform));
        if (name instanceof Name) {
            String colorName = ((Name)name).getName();
            int colorVaue = ColorUtil.convertNamedColor(colorName.toLowerCase());
            if (colorVaue != -1) {
                this.namedColor = new Color(colorVaue);
            } else if (colorName.equals(COLORANT_ALL)) {
                this.isAll = true;
            } else if (colorName.equals(COLORANT_NONE)) {
                this.isNone = true;
            }
        }
    }

    public int getNumComponents() {
        return 1;
    }

    public Color getColor(float[] components) {
        if (this.namedColor != null) {
            this.tint = components[0];
            float[] colour = this.namedColor.getComponents(null);
            this.namedColor = new Color(colour[0], colour[1], colour[2], this.tint);
            return this.namedColor;
        }
        if (this.tintTransform == null) {
            float colour = components[0];
            float[] alternateColour = new float[this.alternate.getNumComponents()];
            int max = this.alternate.getNumComponents();
            for (int i = 0; i < max; ++i) {
                alternateColour[i] = colour;
            }
            return this.alternate.getColor(alternateColour);
        }
        if (this.alternate != null) {
            float[] y = this.tintTransform.calculate(components);
            return this.alternate.getColor(Separation.reverse(y));
        }
        return this.namedColor;
    }

    public float getTint() {
        return this.tint;
    }
}

